/****************************************************************************
 *   $Id:: gpio.c 7573 2011-06-13 20:09:55Z usb01267                        $
 *   Project: NXP LPC11U6x GPIO example
 *
 *   Description:
 *     This file contains GPIO code example which include GPIO 
 *     initialization, GPIO interrupt handler, and related APIs for 
 *     GPIO access.
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
****************************************************************************/
#include "LPC11U6x.h"			/* LPC11U6x Peripheral Registers */
#include "lpc11U6x_gpio.h"
#include "lpc11U6x_nmi.h"

volatile uint32_t pin_int0_counter = 0;
volatile uint32_t pin_int1_counter = 0;
volatile uint32_t pin_int2_counter = 0;
volatile uint32_t pin_int3_counter = 0;
volatile uint32_t pin_int4_counter = 0;
volatile uint32_t pin_int5_counter = 0;
volatile uint32_t pin_int6_counter = 0;
volatile uint32_t pin_int7_counter = 0;
volatile uint32_t gint0_counter = 0;
volatile uint32_t gint1_counter = 0;
volatile uint32_t pin_int0_level_counter = 0;
volatile uint32_t pin_int0_rising_edge_counter = 0;
volatile uint32_t pin_int0_falling_edge_counter = 0;
volatile uint32_t pin_int1_level_counter = 0;
volatile uint32_t pin_int1_rising_edge_counter = 0;
volatile uint32_t pin_int1_falling_edge_counter = 0;
volatile uint32_t pin_int2_level_counter = 0;
volatile uint32_t pin_int2_rising_edge_counter = 0;
volatile uint32_t pin_int2_falling_edge_counter = 0;
volatile uint32_t pin_int3_level_counter = 0;
volatile uint32_t pin_int3_rising_edge_counter = 0;
volatile uint32_t pin_int3_falling_edge_counter = 0;
volatile uint32_t pin_int4_level_counter = 0;
volatile uint32_t pin_int4_rising_edge_counter = 0;
volatile uint32_t pin_int4_falling_edge_counter = 0;
volatile uint32_t pin_int5_level_counter = 0;
volatile uint32_t pin_int5_rising_edge_counter = 0;
volatile uint32_t pin_int5_falling_edge_counter = 0;
volatile uint32_t pin_int6_level_counter = 0;
volatile uint32_t pin_int6_rising_edge_counter = 0;
volatile uint32_t pin_int6_falling_edge_counter = 0;
volatile uint32_t pin_int7_level_counter = 0;
volatile uint32_t pin_int7_rising_edge_counter = 0;
volatile uint32_t pin_int7_falling_edge_counter = 0;
volatile uint32_t gint0_level_counter = 0;
volatile uint32_t gint0_edge_counter = 0;
volatile uint32_t gint1_level_counter = 0;
volatile uint32_t gint1_edge_counter = 0;

/*****************************************************************************
** Function name:		PIN_INT0_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT0_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int0_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 0 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int0_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<0) )
        {
          LPC_PINT->RISE = 0x1<<0;
          pin_int0_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<0) )
        {
          LPC_PINT->FALL = 0x1<<0;
          pin_int0_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<0) )
        {
          LPC_PINT->RISE = 0x1<<0;
          pin_int0_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<0) )
        {
          LPC_PINT->FALL = 0x1<<0;
          pin_int0_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int0_rising_edge_counter++;
        pin_int0_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<0) )
  {
    if ( LPC_PINT->ISEL & (0x1<<0) )
    {
      pin_int0_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<0) ) && ( LPC_PINT->IENR & (0x1<<0) ) )
      {
        GPIOSetBitValue(2, 5,0);
				pin_int0_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<0;
      }
      if ( ( LPC_PINT->FALL & (0x1<<0) ) && ( LPC_PINT->IENF & (0x1<<0) ) )
      {
        GPIOSetBitValue(2, 5,1);
				pin_int0_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<0;
      }
      LPC_PINT->IST = 0x1<<0;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT1_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT1_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int1_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 1 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int1_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<1) )
        {
          LPC_PINT->RISE = 0x1<<1;
          pin_int1_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<1) )
        {
          LPC_PINT->FALL = 0x1<<1;
          pin_int1_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<1) )
        {
          LPC_PINT->RISE = 0x1<<1;
          pin_int1_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<1) )
        {
          LPC_PINT->FALL = 0x1<<1;
          pin_int1_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int1_rising_edge_counter++;
        pin_int1_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<1) )
  {
    if ( LPC_PINT->ISEL & (0x1<<1) )
    {
      pin_int1_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<1) ) && ( LPC_PINT->IENR & (0x1<<1) ) )
      {
        GPIOSetBitValue(2, 10, 0);
				pin_int1_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<1;
      }
      if ( ( LPC_PINT->FALL & (0x1<<1) ) && ( LPC_PINT->IENF & (0x1<<1) ) )
      {
        GPIOSetBitValue(2, 10, 1);
				pin_int1_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<1;
      }
      LPC_PINT->IST = 0x1<<1;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT2_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT2_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int2_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 2 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int2_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<2) )
        {
          LPC_PINT->RISE = 0x1<<2;
          pin_int2_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<2) )
        {
          LPC_PINT->FALL = 0x1<<2;
          pin_int2_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<2) )
        {
          LPC_PINT->RISE = 0x1<<2;
          pin_int2_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<2) )
        {
          LPC_PINT->FALL = 0x1<<2;
          pin_int2_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int2_rising_edge_counter++;
        pin_int2_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<2) )
  {
    if ( LPC_PINT->ISEL & (0x1<<2) )
    {
      pin_int2_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<2) ) && ( LPC_PINT->IENR & (0x1<<2) ) )
      {
        GPIOSetBitValue(2, 10, 0);
				pin_int2_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<2;
      }
      if ( ( LPC_PINT->FALL & (0x1<<2) ) && ( LPC_PINT->IENF & (0x1<<2) ) )
      {
         GPIOSetBitValue(2, 10, 1);
				pin_int2_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<2;
      }
      LPC_PINT->IST = 0x1<<2;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT3_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT3_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int3_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 3 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int3_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<3) )
        {
          LPC_PINT->RISE = 0x1<<3;
          pin_int3_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<3) )
        {
          LPC_PINT->FALL = 0x1<<3;
          pin_int3_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<3) )
        {
          LPC_PINT->RISE = 0x1<<3;
          pin_int3_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<3) )
        {
          LPC_PINT->FALL = 0x1<<3;
          pin_int3_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int3_rising_edge_counter++;
        pin_int3_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<3) )
  {
    if ( LPC_PINT->ISEL & (0x1<<3) )
    {
      pin_int3_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<3) ) && ( LPC_PINT->IENR & (0x1<<3) ) )
      {
        GPIOSetBitValue(2, 2, 0);
				pin_int3_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<3;
      }
      if ( ( LPC_PINT->FALL & (0x1<<3) ) && ( LPC_PINT->IENF & (0x1<<3) ) )
      {
        GPIOSetBitValue(2, 2, 1);
				pin_int3_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<3;
      }
      LPC_PINT->IST = 0x1<<3;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT4_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT4_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int4_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 4 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int4_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<4) )
        {
          LPC_PINT->RISE = 0x1<<4;
          pin_int4_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<4) )
        {
          LPC_PINT->FALL = 0x1<<4;
          pin_int4_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<4) )
        {
          LPC_PINT->RISE = 0x1<<4;
          pin_int4_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<4) )
        {
          LPC_PINT->FALL = 0x1<<4;
          pin_int4_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int4_rising_edge_counter++;
        pin_int4_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<4) )
  {
    if ( LPC_PINT->ISEL & (0x1<<4) )
    {
      pin_int4_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<4) ) && ( LPC_PINT->IENR & (0x1<<4) ) )
      {
        GPIOSetBitValue(2, 5, 0);
				pin_int4_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<4;
      }
      if ( ( LPC_PINT->FALL & (0x1<<4) ) && ( LPC_PINT->IENF & (0x1<<4) ) )
      {
        GPIOSetBitValue(2, 5, 1);
				pin_int4_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<4;
      }
      LPC_PINT->IST = 0x1<<4;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT5_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT5_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int5_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 5 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int5_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<5) )
        {
          LPC_PINT->RISE = 0x1<<5;
          pin_int5_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<5) )
        {
          LPC_PINT->FALL = 0x1<<5;
          pin_int5_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<5) )
        {
          LPC_PINT->RISE = 0x1<<5;
          pin_int5_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<5) )
        {
          LPC_PINT->FALL = 0x1<<5;
          pin_int5_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int5_rising_edge_counter++;
        pin_int5_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<5) )
  {
    if ( LPC_PINT->ISEL & (0x1<<5) )
    {
      pin_int5_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<5) ) && ( LPC_PINT->IENR & (0x1<<5) ) )
      {
        GPIOSetBitValue(2, 5, 0);
				GPIOSetBitValue(2, 10, 0);
				GPIOSetBitValue(2, 2, 0);
				pin_int5_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<5;
      }
      if ( ( LPC_PINT->FALL & (0x1<<5) ) && ( LPC_PINT->IENF & (0x1<<5) ) )
      {
        GPIOSetBitValue(2, 5, 1);
				GPIOSetBitValue(2, 10, 1);
				GPIOSetBitValue(2, 2, 1);
				pin_int5_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<5;
      }
      LPC_PINT->IST = 0x1<<5;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT6_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT6_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int6_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 6 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int6_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<6) )
        {
          LPC_PINT->RISE = 0x1<<6;
          pin_int6_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<6) )
        {
          LPC_PINT->FALL = 0x1<<6;
          pin_int6_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<6) )
        {
          LPC_PINT->RISE = 0x1<<6;
          pin_int6_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<6) )
        {
          LPC_PINT->FALL = 0x1<<6;
          pin_int6_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int6_rising_edge_counter++;
        pin_int6_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<6) )
  {
    if ( LPC_PINT->ISEL & (0x1<<6) )
    {
      pin_int6_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<6) ) && ( LPC_PINT->IENR & (0x1<<6) ) )
      {
        GPIOSetBitValue(2, 5, 0);
				GPIOSetBitValue(2, 2, 0);
				pin_int6_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<6;
      }
      if ( ( LPC_PINT->FALL & (0x1<<6) ) && ( LPC_PINT->IENF & (0x1<<6) ) )
      {
				GPIOSetBitValue(2, 5, 1);
				GPIOSetBitValue(2, 2, 1);
        pin_int6_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<6;
      }
      LPC_PINT->IST = 0x1<<6;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		PIN_INT7_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void PIN_INT7_IRQHandler(void)
{
	uint32_t condition, regVal;

  pin_int7_counter++;
  if ( LPC_PINT->PMCTRL & SEL_PMATCH )
  {
    condition = ( LPC_PINT->PMCFG >> (8 + 7 * 3) ) & 0x7;
    switch ( condition )
    {
      case PATTERN_LEVEL_HI: 
      case PATTERN_LEVEL_LO:
        pin_int7_level_counter++;
        break;
      case PATTERN_RISING:
        if ( LPC_PINT->RISE & (0x1<<7) )
        {
          LPC_PINT->RISE = 0x1<<7;
          pin_int7_rising_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_FALLING:
        if ( LPC_PINT->FALL & (0x1<<7) )
        {
          LPC_PINT->FALL = 0x1<<7;
          pin_int7_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_R_OR_F:
        if ( LPC_PINT->RISE & (0x1<<7) )
        {
          LPC_PINT->RISE = 0x1<<7;
          pin_int7_rising_edge_counter++;
        }
        if ( LPC_PINT->FALL & (0x1<<7) )
        {
          LPC_PINT->FALL = 0x1<<7;
          pin_int7_falling_edge_counter++;
        }
        regVal = LPC_PINT->PMSRC;
        LPC_PINT->PMSRC = regVal;
        break;
      case PATTERN_EVENT:
        /* Non-sticky, won't know if it's rising or falling, increment both. */
        pin_int7_rising_edge_counter++;
        pin_int7_falling_edge_counter++;
        break;
      default:
        break;
    }
    return;	
  }
	/* regular pin interrupt */
  if ( LPC_PINT->IST & (0x1<<7) )
  {
    if ( LPC_PINT->ISEL & (0x1<<7) )
    {
      pin_int7_level_counter++;
    }
    else
    {
      if ( ( LPC_PINT->RISE & (0x1<<7) ) && ( LPC_PINT->IENR & (0x1<<7) ) )
      {
        pin_int7_rising_edge_counter++;
        LPC_PINT->RISE = 0x1<<7;
      }
      if ( ( LPC_PINT->FALL & (0x1<<7) ) && ( LPC_PINT->IENF & (0x1<<7) ) )
      {
        pin_int7_falling_edge_counter++;
        LPC_PINT->FALL = 0x1<<7;
      }
      LPC_PINT->IST = 0x1<<7;
    }
  }		
  return;
}

/*****************************************************************************
** Function name:		GINT0_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void GINT0_IRQHandler(void)
{
  gint0_counter++;
  if ( LPC_GINT0->CTRL & 0x1 )
  {
    if ( LPC_GINT0->CTRL & (0x1<<2) )
    {
      gint0_level_counter++;
    }
    else
    {
      gint0_edge_counter++;
    }
    LPC_GINT0->CTRL |= 0x1;
  }		
  return;
}

/*****************************************************************************
** Function name:		GINT1_IRQHandler
**
** Descriptions:		Use one GPIO pin as interrupt source
**
** parameters:			None
** 						
** Returned value:		None
** 
*****************************************************************************/
void GINT1_IRQHandler(void)
{
  gint1_counter++;
  if ( LPC_GINT1->CTRL & 0x1 )
  {
    if ( LPC_GINT1->CTRL & (0x1<<2) )
    {
      gint1_level_counter++;
    }
    else
    {
      gint1_edge_counter++;
    }
    LPC_GINT1->CTRL |= 0x1;
  }		
  return;
}

/*****************************************************************************
** Function name:		GPIOInit
**
** Descriptions:		Initialize GPIO, install the
**						GPIO interrupt handler
**
** parameters:			None
** 						
** Returned value:		true or false, return false if the VIC table
**						is full and GPIO interrupt handler can be
**						installed.
** 
*****************************************************************************/
void GPIOInit( void )
{
  /* Enable AHB clock to the GPIO domain. */
  LPC_SYSCON->SYSAHBCLKCTRL |= (1<<6);

  /* Enable AHB clock to the PinInt, GroupedInt domain. */
  LPC_SYSCON->SYSAHBCLKCTRL |= ((1<<19) | (1<<23) | (1<<24));
	
	//BUTTON B2
	GPIOSetDir( PORT0, 20, 0 );
	//BUTTON B3
	GPIOSetDir( PORT0, 21, 0 );
	//JOYSTICK UP
	GPIOSetDir( PORT0,  7, 0 );
	//JOYSTICK DOWN
	GPIOSetDir( PORT1, 23, 0 );
	//JOYSTICK LEFT
	GPIOSetDir( PORT0, 22, 0 );
	//JOYSTICK RIGHT
  GPIOSetDir( PORT0, 23, 0 );
	//JOYSTICK SELECT
	GPIOSetDir( PORT0, 16, 0 );

	// LCDM BACKLIGHT
  GPIOSetDir(PORT1, 20, 1 );
	GPIOSetBitValue(PORT1, 20, 1);
	
	GPIOSetDir(PORT1, 24, 1 );
	GPIOSetBitValue(PORT1, 24, 0);

	// Set LED to output & Close
	GPIOSetBitValue(PORT2, 2,0);
	GPIOSetBitValue(PORT2, 5,0);
	GPIOSetBitValue(PORT2,10,0);
	
	GPIOSetDir( PORT2,  2, 1);				// LED1
	GPIOSetDir( PORT2,  5, 1);				// LED2
	GPIOSetDir( PORT2, 10, 1);				// LED3
	
	// SPI Flash CS
	GPIOSetDir( PORT1 , 13, 1);
	GPIOSetBitValue(PORT1,13,1);
  return;
}

/*****************************************************************************
** Function name:		GPIOSetPinInterrupt
**
** Descriptions:		Set interrupt sense, event, etc.
**						sense: edge or level, 0 is edge, 1 is level 
**						event/polarity: 0 is active low/falling, 1 is high/rising.
**
** parameters:			channel #, port #, bit position, sense, event(polarity)
** 						
** Returned value:		None
** 
*****************************************************************************/
void GPIOSetPinInterrupt( uint32_t channelNum, uint32_t portNum, uint32_t bitPosi,
		uint32_t sense, uint32_t event )
{
  switch ( channelNum )
  {
	case CHANNEL0:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[0] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[0] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[0] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT0_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT0_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT0_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT0_IRQn);
#endif
	break;
	case CHANNEL1:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[1] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[1] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[1] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT1_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT1_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT1_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT1_IRQn);
#endif
	break;
	case CHANNEL2:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[2] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[2] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[2] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT2_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT2_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT2_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT2_IRQn);
#endif
	break;
	case CHANNEL3:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[3] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[3] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[3] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT3_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT3_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT3_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT3_IRQn);
#endif
	break;
	case CHANNEL4:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[4] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[4] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[4] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT4_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT4_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT4_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT4_IRQn);
#endif
	break;
	case CHANNEL5:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[5] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[5] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[5] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT5_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT5_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT5_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT5_IRQn);
#endif
	break;
	case CHANNEL6:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[6] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[6] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[6] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT6_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT6_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT6_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT6_IRQn);
#endif
	break;
	case CHANNEL7:
	  if ( portNum == 2)
	  {
		LPC_SYSCON->PINTSEL[7] = bitPosi + 24 + 32; 
	  }
	  else if ( portNum == 1)
	  {
		LPC_SYSCON->PINTSEL[7] = bitPosi + 24; 
	  }
	  else
	  {
		LPC_SYSCON->PINTSEL[7] = bitPosi; 
	  }
	  LPC_PINT->RISE = 0x1<<channelNum;
	  LPC_PINT->FALL = 0x1<<channelNum;
	  NVIC_DisableIRQ(PIN_INT7_IRQn);
	  NVIC_ClearPendingIRQ(PIN_INT7_IRQn);
#if NMI_ENABLED
	  NMI_Init(PIN_INT7_IRQn);
#else
	  NVIC_EnableIRQ(PIN_INT7_IRQn);
#endif
	break;
	default:
	  break;
  }
  if ( sense == 0 )
  {
	LPC_PINT->ISEL &= ~(0x1<<channelNum);	/* Edge trigger */
	if ( event == 0 )
	{
	  LPC_PINT->IENF |= (0x1<<channelNum);	/* faling edge */
	}
	else
	{
	  LPC_PINT->IENR |= (0x1<<channelNum);	/* Rising edge */
	}
  }
  else
  {
	LPC_PINT->ISEL |= (0x1<<channelNum);	/* Level trigger. */
	LPC_PINT->IENR |= (0x1<<channelNum);	/* Level enable */
	if ( event == 0 )
	{
	  LPC_PINT->IENF &= ~(0x1<<channelNum);	/* active-low */
	}
	else
	{
	  LPC_PINT->IENF |= (0x1<<channelNum);	/* active-high */
	}
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOPinIntEnable
**
** Descriptions:		Enable Interrupt
**
** parameters:			channel num, event(0 is falling edge, 1 is rising edge)
** Returned value:		None
** 
*****************************************************************************/
void GPIOPinIntEnable( uint32_t channelNum, uint32_t event )
{
  if ( !( LPC_PINT->ISEL & (0x1<<channelNum) ) )
  {
    if ( event == 0 )
    {
      LPC_PINT->SIENF |= (0x1<<channelNum);	/* faling edge */
    }
    else
    {
      LPC_PINT->SIENR |= (0x1<<channelNum);	/* Rising edge */
    }
  }
  else
  {
    LPC_PINT->SIENR |= (0x1<<channelNum);	/* Level */
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOPinIntDisable
**
** Descriptions:		Disable Interrupt
**
** parameters:			channel num, event(0 is falling edge, 1 is rising edge)
** 						
** Returned value:		None
** 
*****************************************************************************/
void GPIOPinIntDisable( uint32_t channelNum, uint32_t event )
{
  if ( !( LPC_PINT->ISEL & (0x1<<channelNum) ) )
  {
    if ( event == 0 )
    {
      LPC_PINT->CIENF |= (0x1<<channelNum);	/* faling edge */
    }
    else
    {
      LPC_PINT->CIENR |= (0x1<<channelNum);	/* Rising edge */
    }
  }
  else
  {
    LPC_PINT->CIENR |= (0x1<<channelNum);	/* Level */
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOPinIntStatus
**
** Descriptions:		Get Interrupt status
**
** parameters:			channel num
** 						
** Returned value:		None
** 
*****************************************************************************/
uint32_t GPIOPinIntStatus( uint32_t channelNum )
{
  if ( LPC_PINT->IST & (0x1<<channelNum) )
  {
    return( 1 );
  }
  else
  {
    return( 0 );
  }
}

/*****************************************************************************
** Function name:		GPIOPinIntClear
**
** Descriptions:		Clear Interrupt
**
** parameters:			channel num
** 						
** Returned value:		None
** 
*****************************************************************************/
void GPIOPinIntClear( uint32_t channelNum )
{
  if ( !( LPC_PINT->ISEL & (0x1<<channelNum) ) )
  {
    LPC_PINT->IST = (1<<channelNum);
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOSetGroupedInterrupt
**
** Descriptions:		Set interrupt logic, sense, eventPattern, etc.
**						logic: AND or OR, 0 is OR, 1 is AND 
**						sensePattern: edge or level, 0 is edge, 1 is level 
**						event/polarity: 0 is active low/falling, 1 is high/rising.
**
** parameters:			group #, bit pattern, logic, sense, event(polarity) pattern
** 						
** Returned value:		None
** 
*****************************************************************************/
void GPIOSetGroupedInterrupt( uint32_t groupNum, uint32_t *bitPattern, uint32_t logic,
		uint32_t sense, uint32_t *eventPattern )
{
  switch ( groupNum )
  {
    case GROUP0:
      if ( sense == 0 )
      {
        LPC_GINT0->CTRL &= ~(0x1<<2);	/* Edge trigger */
      }
      else
      {
        LPC_GINT0->CTRL |= (0x1<<2);	/* Level trigger. */
      }
      if ( logic == 0 )
      {
        LPC_GINT0->CTRL &= ~(0x1<<1);
      }
      else
      {
        LPC_GINT0->CTRL |= (0x1<<1);
      }
      LPC_GINT0->PORT_POL[0] = *((uint32_t *)(eventPattern + 0));
      LPC_GINT0->PORT_POL[1] = *((uint32_t *)(eventPattern + 1));
      LPC_GINT0->PORT_POL[2] = *((uint32_t *)(eventPattern + 2));
      LPC_GINT0->PORT_ENA[0] = *((uint32_t *)(bitPattern + 0));
      LPC_GINT0->PORT_ENA[1] = *((uint32_t *)(bitPattern + 1));
      LPC_GINT0->PORT_ENA[2] = *((uint32_t *)(bitPattern + 2));
      /* as soon as enabled, an edge may be generated       */
      /* clear interrupt flag and NVIC pending interrupt to */
      /* workaround the potential edge generated as enabled */
      LPC_GINT0->CTRL |= (1<<0);
      NVIC_DisableIRQ(GINT0_IRQn);
      NVIC_ClearPendingIRQ(GINT0_IRQn);
#if NMI_ENABLED
      NMI_Init(GINT0_IRQn);
#else
      NVIC_EnableIRQ(GINT0_IRQn);
#endif
      break;
    case GROUP1:
      if ( sense == 0 )
      {
        LPC_GINT1->CTRL &= ~(0x1<<2);	/* Edge trigger */
      }
      else
      {
        LPC_GINT1->CTRL |= (0x1<<2);	/* Level trigger. */
      }
      if ( logic == 0 )
      {
        LPC_GINT1->CTRL &= ~(0x1<<1);
      }
      else
      {
        LPC_GINT1->CTRL |= (0x1<<1);
      }
      LPC_GINT1->PORT_POL[0] = *((uint32_t *)(eventPattern + 0));
      LPC_GINT1->PORT_POL[1] = *((uint32_t *)(eventPattern + 1));
      LPC_GINT1->PORT_POL[2] = *((uint32_t *)(eventPattern + 2));
      LPC_GINT1->PORT_ENA[0] = *((uint32_t *)(bitPattern + 0));
      LPC_GINT1->PORT_ENA[1] = *((uint32_t *)(bitPattern + 1));
      LPC_GINT1->PORT_ENA[2] = *((uint32_t *)(bitPattern + 2));
      /* as soon as enabled, an edge may be generated       */
      /* clear interrupt flag and NVIC pending interrupt to */
      /* workaround the potential edge generated as enabled */
      LPC_GINT1->CTRL |= (1<<0);
      NVIC_DisableIRQ(GINT1_IRQn);
      NVIC_ClearPendingIRQ(GINT1_IRQn);
#if NMI_ENABLED
      NMI_Init(GINT1_IRQn);
#else
      NVIC_EnableIRQ(GINT1_IRQn);
#endif
      break;
    default:
      break;
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOPatternMatchInit
**
** Descriptions:		Initialize pattern match to constant 0, disable any unused slices.
**
** parameters:			None
** 						
** Returned value:	None
**
*****************************************************************************/
void GPIOPatternMatchInit( void )
{
  LPC_PINT->PMCFG = (PATTERN_CONST_0<<BIT_SLICE0) |
                  (PATTERN_CONST_0<<BIT_SLICE1) |
                  (PATTERN_CONST_0<<BIT_SLICE2) |
                  (PATTERN_CONST_0<<BIT_SLICE3) |
                  (PATTERN_CONST_0<<BIT_SLICE4) |
                  (PATTERN_CONST_0<<BIT_SLICE5) |
                  (PATTERN_CONST_0<<BIT_SLICE6) |
                  (PATTERN_CONST_0<<BIT_SLICE7);
	return;
}

/*****************************************************************************
** Function name:		GPIOSetPatternMatchInput
**
** Descriptions:		Set pattern match input, map to PINTSEL register.
**
** parameters:			channel #, port #, and port pin
** 						
** Returned value:	None
**
*****************************************************************************/
void GPIOSetPatternMatchInput( uint32_t channelNum, uint32_t portNum, uint32_t bitPosi )
{
  if ( portNum == 0 ) {
		LPC_SYSCON->PINTSEL[channelNum] = bitPosi; 
  }
  else if ( portNum == 1 ) {
		LPC_SYSCON->PINTSEL[channelNum] = bitPosi + 24; 
  }
  else {
		LPC_SYSCON->PINTSEL[channelNum] = bitPosi + 24 + 32; 
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOSetPatternMatchSlice
**
** Descriptions:		Set the pattern match slice based on the input
**
** parameters:			channel #, slice #, condition, and product EP 
** 						
** Returned value:	None
**
*****************************************************************************/
void GPIOSetPatternMatchSlice( uint32_t channelNum, uint32_t sliceNum, uint32_t condition, uint32_t isProdEP  )
{
  LPC_PINT->PMSRC &= ~(0x7 << (8 + sliceNum * 3));
  LPC_PINT->PMSRC |= (channelNum << (8 + sliceNum * 3));
  LPC_PINT->PMCFG &= ~(0x7 << (8 + sliceNum * 3));
  LPC_PINT->PMCFG |= (condition << (8 + sliceNum * 3));
  if ( isProdEP  )
  {
    if ( sliceNum != 7 )
    {
      LPC_PINT->PMCFG |= (0x1 << sliceNum);
    }
    NVIC_DisableIRQ((IRQn_Type)(PIN_INT0_IRQn+sliceNum));
    NVIC_ClearPendingIRQ((IRQn_Type)(PIN_INT0_IRQn+sliceNum));
#if NMI_ENABLED
    NMI_Init((IRQn_Type)(PIN_INT0_IRQn+sliceNum));
#else
    NVIC_EnableIRQ((IRQn_Type)(PIN_INT0_IRQn+sliceNum));
#endif
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOPatternMatchEnable
**
** Descriptions:		Enable the pattern match engine, called only after inputs 
**									and slices are configured. 
**
** parameters:			RxEv enable flag (TRUE or FALSE )
** 						
** Returned value:	None
**
*****************************************************************************/
void GPIOPatternMatchEnable( uint32_t PMatchSel, uint32_t RxEvEna )
{
	LPC_PINT->PMCTRL &= ~(SEL_PMATCH | ENA_PXEV);

	if ( PMatchSel )
  {
    LPC_PINT->PMCTRL |= SEL_PMATCH;
  }	
  if ( RxEvEna )
  {
    LPC_PINT->PMCTRL |= ENA_PXEV;
  }
	return;
}

/*****************************************************************************
** Function name:		GPIOGetPinValue
**
** Descriptions:		Read Current state of port pin, PIN register value
**
** parameters:			port num, bit position
** Returned value:		None
**
*****************************************************************************/
uint32_t GPIOGetPinValue( uint32_t portNum, uint32_t bitPosi )
{
  uint32_t regVal = 0;	

  if( bitPosi < 0x20 )
  {	
	if ( LPC_GPIO_PORT->PIN[portNum] & (0x1<<bitPosi) )
	{
	  regVal = 1;
	}
  }
  else if( bitPosi == 0xFF )
  {
	regVal = LPC_GPIO_PORT->PIN[portNum];
  }
  return ( regVal );		
}

/*****************************************************************************
** Function name:		GPIOSetBitValue
**
** Descriptions:		Set/clear a bit in a specific position
**
** parameters:			port num, bit position, bit value
** 						
** Returned value:		None
**
*****************************************************************************/
void GPIOSetBitValue( uint32_t portNum, uint32_t bitPosi, uint32_t bitVal )
{
  if ( bitVal )
  {
	LPC_GPIO_PORT->SET[portNum] = 1<<bitPosi;
  }
  else
  {
	LPC_GPIO_PORT->CLR[portNum] = 1<<bitPosi;
  }
  return;
}

/*****************************************************************************
** Function name:		GPIOSetDir
**
** Descriptions:		Set the direction in GPIO port
**
** parameters:			portNum, bit position, direction (1 out, 0 input)
** 						
** Returned value:		None
**
*****************************************************************************/
void GPIOSetDir( uint32_t portNum, uint32_t bitPosi, uint32_t dir )
{
  if( dir )
  {
	LPC_GPIO_PORT->DIR[portNum] |= (1<<bitPosi);
  }
  else
  {
	LPC_GPIO_PORT->DIR[portNum] &= ~(1<<bitPosi);
  }
  return;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
